/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.util.Map;
import java.util.Set;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.priv.ChannelFactory;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RunGenericRootCommand
implements VerificationConstants {
    String[] m_nodeList;
    String[] m_env = null;
    String[] m_args = null;
    String m_location;
    String m_command;
    UserInfo m_userInfo;
    int m_timeout;
    ConfigurationSetup.ConfigMethod m_mode;
    ResultSet m_resultSet;
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public RunGenericRootCommand(String[] nodeList, String command, String[] env, String[] args, RootUserCredentials rootCreds, int timeout, ResultSet resultSet) throws RootAutomationNotConfiguredException {
        this(nodeList, command, env, args, rootCreds.getRootUserCredentials(), rootCreds.getRootExecutionMode(), rootCreds.getSudoPbrunLocation(), timeout, resultSet);
    }

    public RunGenericRootCommand(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, ConfigurationSetup.ConfigMethod mode, String location, int timeout, ResultSet resultSet) {
        this.m_userInfo = userInfo;
        this.m_mode = mode;
        this.m_resultSet = resultSet;
        this.m_timeout = timeout;
        this.m_command = command;
        this.m_location = location;
        this.m_nodeList = new String[nodeList.length];
        System.arraycopy(nodeList, 0, this.m_nodeList, 0, nodeList.length);
        if (args != null) {
            this.m_args = new String[args.length];
            System.arraycopy(args, 0, this.m_args, 0, args.length);
        }
        if (env != null) {
            this.m_env = new String[env.length];
            System.arraycopy(env, 0, this.m_env, 0, env.length);
        }
    }

    public boolean execute() {
        Map cmdResultMap = null;
        boolean bResult = false;
        Trace.out((String)"Entry");
        try {
            ChannelFactory cf = ChannelFactory.getInstance();
            if (this.m_mode == ConfigurationSetup.ConfigMethod.ROOT) {
                if (this.m_args == null && this.m_env == null) {
                    Trace.out((String)"executing root command with no args or env");
                    cmdResultMap = cf.executeCommand(this.m_nodeList, this.m_command, this.m_userInfo, this.m_timeout);
                } else {
                    Trace.out((String)"executing root command with args and env");
                    cmdResultMap = cf.executeCommand(this.m_nodeList, this.m_command, this.m_env, this.m_args, this.m_userInfo, this.m_timeout);
                }
            } else if (this.m_args == null && this.m_env == null) {
                Trace.out((String)"executing sudo/pbrun command with no args or env");
                cmdResultMap = cf.executeCommand(this.m_nodeList, this.m_command, this.m_mode, this.m_location, this.m_userInfo, this.m_timeout);
            } else {
                Trace.out((String)"executing sudo/pbrun command with args and env");
                cmdResultMap = cf.executeCommand(this.m_nodeList, this.m_command, this.m_env, this.m_args, this.m_mode, this.m_location, this.m_userInfo, this.m_timeout);
            }
            for (Map.Entry entry : cmdResultMap.entrySet()) {
                String node = (String)entry.getKey();
                CommandResult result = (CommandResult)entry.getValue();
                this.m_resultSet.addResult(node, 1);
                String[] resultStringArr = result.getResultString();
                String reoutput = VerificationUtil.strArr2String(resultStringArr, LSEP);
                Trace.out((String)("output: " + reoutput));
                this.m_resultSet.getResult(node).addResultInfo(reoutput);
                this.m_resultSet.getResult(node).addResultInfo(resultStringArr);
            }
            bResult = true;
        }
        catch (ChannelException e) {
            Trace.out((String)("Received ChannelException while executing command " + this.m_command + " message is: " + e.getMessage()));
            VerificationLogData.logError("Channel exception while running command " + this.m_command + " message is " + e.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String errMsg = e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return bResult;
        }
        catch (CompositeOperationException e) {
            Trace.out((String)("Received CompositeOperationException  " + e.getMessage()));
            VerificationLogData.logError("Channel exception while running command " + this.m_command + " message is " + e.getMessage());
            try {
                Set compositeErrorSet = e.getOperationIdentifier();
                for (Object obj : compositeErrorSet) {
                    ErrorDescription ed;
                    String errMsg;
                    String node = (String)obj;
                    NativeResult nativeResult = e.getNativeResult(obj);
                    int osErrorCode = nativeResult.getOSErrCode();
                    if (e.getStatus(obj) == CompositeOperationException.Status.SUCCESS) {
                        if (osErrorCode <= 2) {
                            Trace.out((String)("execution successful on node: " + node));
                            this.m_resultSet.addResult(node, 1);
                            String[] resultStringArr = nativeResult.getResultString();
                            String reoutput = VerificationUtil.strArr2String(resultStringArr);
                            this.m_resultSet.getResult(node).addResultInfo(reoutput);
                            this.m_resultSet.getResult(node).addResultInfo(resultStringArr);
                            continue;
                        }
                        this.m_resultSet.addResult(node, 2);
                        errMsg = e.getMessage() + LSEP + VerificationUtil.strArr2String(nativeResult.getOutputString(), LSEP);
                        ed = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node, ed);
                        continue;
                    }
                    if (e.getStatus(obj) == CompositeOperationException.Status.FAILURE) {
                        Trace.out((String)"composite operation exception is having failure status");
                        this.m_resultSet.addResult(node, 2);
                        errMsg = s_gMsgBundle.getMessage("11303", true, (Object[])new String[]{node}) + LSEP + e.getMessage();
                        String[] resultStringArr = nativeResult.getResultString();
                        if (resultStringArr != null) {
                            errMsg = errMsg + LSEP + VerificationUtil.strArr2String(resultStringArr);
                        }
                        ErrorDescription ed2 = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node, ed2);
                        continue;
                    }
                    this.m_resultSet.addResult(node, 2);
                    errMsg = e.getException(obj).getMessage();
                    ed = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(node, ed);
                }
            }
            catch (NoSuchIdentifierException ne) {
                VerificationLogData.logError("Channel exception while running command " + this.m_command + " message is " + e.getMessage());
                Trace.out((String)ne.getMessage());
            }
            return bResult;
        }
        return bResult;
    }
}

